#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.FrmConfigureComponents;
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_LabTest : BaseTest 
	{
		private DataTable _dtLabTest;

		private BOL.LabTest _tstLT;
		private DataRow _drLabTest;
		

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtLabTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM SpecimenTestThreshold WHERE ComponentClassId IS NOT NULL AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' ORDER by LastUpdateDate DESC", false);
				if (this._dtLabTest.Rows.Count == 0)
				{
					BOL.LabTest tmpLT = new BOL.LabTest();
					DataTable dtLT = SprocHelper.GetInsertSpecimenTestThresholdSprocTable(Guid.NewGuid(), "1");
					tmpLT.SaveLabTests(dtLT, COMMON.UpdateFunction.UnitTests);

					this._dtLabTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM SpecimenTestThreshold WHERE ComponentClassId IS NOT NULL AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' ORDER by LastUpdateDate DESC", true);
				}
				this._drLabTest = this._dtLabTest.Rows[0];

				this.RefreshData = false;
			}

			_tstLT = new gov.va.med.vbecs.BOL.LabTest(this._drLabTest);
			this._tstLT.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.Default);

			VistALinkUnitTestHarness.RequireConnection();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection();
		}

		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.LabTest tstValue = new BOL.LabTest();

			Assert.IsNotNull(tstValue);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}


		[Test]
		public void Ctor_DataRow_Pass()
		{
			_tstLT = new BOL.LabTest(_drLabTest);
			Assert.AreEqual(_tstLT.SpecimenTestThresholdGuid, new Guid(_drLabTest[TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid].ToString()));
			Assert.AreEqual(_tstLT.ComponentClassId, Convert.ToInt32(_drLabTest[TABLES.SpecimenTestThreshold.ComponentClassId].ToString()));
			Assert.AreEqual(_tstLT.LabTestName, _drLabTest[TABLES.SpecimenTestThreshold.VistaLaboratoryTestName].ToString());
			Assert.AreEqual(_tstLT.SpecimenType, Common.Utility.GetSpecimenTypeFromString(_drLabTest[TABLES.SpecimenTestThreshold.SpecimenTypeCode].ToString()));
			Assert.AreEqual(_tstLT.LabTestId.ToString().Trim(), _drLabTest[TABLES.SpecimenTestThreshold.LabTestId].ToString().Trim());
			Assert.AreEqual(_tstLT.Threshold, _drLabTest.IsNull(TABLES.SpecimenTestThreshold.ThresholdResult) ? "" : _drLabTest[TABLES.SpecimenTestThreshold.ThresholdResult].ToString());
			if (_tstLT.ReportType == Common.ReportType.Unknown)
			{
				Assert.AreEqual(_drLabTest[TABLES.SpecimenTestThreshold.ReportTypeId].ToString(), string.Empty);
			}
			else
			{
				Assert.AreEqual(_tstLT.ReportType, Common.Utility.GetReportTypeFromInt((Convert.ToInt32(_drLabTest[TABLES.SpecimenTestThreshold.ReportTypeId]))));
			}
			Assert.AreEqual(_tstLT.RecordStatusCode, Common.Utility.GetRecordStatusCodeFromString(_drLabTest[TABLES.SpecimenTestThreshold.RecordStatusCode].ToString()));
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(FormatException))]
		public void Ctor_DataRow_Fail()
		{
			DataTable dataTable = this._dtLabTest.Clone();
			DataRow dr = dataTable.NewRow();

			_tstLT = new BOL.LabTest(dr);
		}		

		[Test]
		public void RecordStatusCode_Pass()
		{
			this._tstLT.RecordStatusCode = Common.RecordStatusCode.NationalStandard;
			Assert.AreEqual(this._tstLT.RecordStatusCode, Common.RecordStatusCode.NationalStandard);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}

		
		[Test]
		public void SpecimenTestThresholdGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();
			
			_tstLT.SpecimenTestThresholdGuid = tstValue;

			Assert.AreEqual(tstValue, _tstLT.SpecimenTestThresholdGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SpecimenTestThresholdGuid_Fail()
		{
		}

		[Test]
		public void ComponentClassID_Pass()
		{
			int tstValue = new Random().Next(1,9999);

			_tstLT.ComponentClassId = tstValue;

			Assert.AreEqual(tstValue, _tstLT.ComponentClassId);
		}

		[Test]
		public void ComponentClassID_Fail()
		{
			_tstLT.ComponentClassId = Int32.MinValue;

			Assert.IsTrue(_tstLT.IsRuleBroken(BROKEN.ComponentClassId));
		}

		[Test]
		public void LabTestName_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();
			_tstLT.LabTestName= tstValue;
			
			Assert.AreEqual(tstValue, this._tstLT.LabTestName);
			Assert.AreEqual(true, this._tstLT.IsRuleBroken(BROKEN.SpecimenType), "BrokenRule.SpecimenType");
			Assert.AreEqual(true, this._tstLT.IsRuleBroken(BROKEN.Threshold), "BrokenRule.Threshold");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LabTestName_Fail()
		{
			//LabTestName is not a brokenrule, so it's same as above
		}

		[Test]
		public void SpecimenType_Pass()
		{
			_tstLT.SpecimenType = Common.SpecimenType.Blood;

			Assert.AreEqual(Common.SpecimenType.Blood, this._tstLT.SpecimenType);
			Assert.AreEqual(false, this._tstLT.IsRuleBroken(BROKEN.SpecimenType), "BrokenRule");
		}

		[Test]
		public void SpecimenType_Fail()
		{
			_tstLT.SpecimenType = Common.SpecimenType.Unknown;

			Assert.AreEqual(true, this._tstLT.IsRuleBroken(BROKEN.SpecimenType), "BrokenRule");
		}

		[Test]
		public void Threshold_Pass()
		{
			this._tstLT.ThresholdType = Common.ThresholdType.Numeric;
			this._tstLT.Threshold = "<123.01";

			Assert.AreEqual(false, this._tstLT.IsRuleBroken(BROKEN.Threshold));
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void TextThreshold_Fail()
		{
			this._tstLT.ThresholdType = Common.ThresholdType.Numeric;
			this._tstLT.Threshold = "ABCDEFG";
		}

		[Test]
		public void ThresholdType_Pass()
		{
			this._tstLT.ThresholdType = Common.ThresholdType.Text;

			Assert.AreEqual(Common.ThresholdType.Text, this._tstLT.ThresholdType);
		}

		[Test]
		public void  ThresholdType_Fail()
		{
			this._tstLT.ThresholdType = Common.ThresholdType.Numeric;
			this._tstLT.Threshold = "<123.01";
			Assert.AreEqual(false, this._tstLT.IsRuleBroken(BROKEN.Threshold));

			this._tstLT.ThresholdType = Common.ThresholdType.Text;
			Assert.AreEqual(true, this._tstLT.IsRuleBroken(BROKEN.Threshold), "BrokenRule");

		}

		[Test]
		public void ReportType_Pass()
		{
			this._tstLT.ReportType = Common.ReportType.DownTime;

			Assert.AreEqual(Common.ReportType.DownTime, _tstLT.ReportType);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReportType_Fail()
		{
			//No broken rule, code in BOL does nothing
		}

		[Test]
		public void LabTestId_Pass()
		{
			int tstValue = new Random().Next(1,99999);

			this._tstLT.LabTestId = tstValue;
			
			Assert.AreEqual(tstValue, this._tstLT.LabTestId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void  LabTestId_Fail()
		{
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow dr = _tstLT.LoadDataRowFromThis(this._dtLabTest.NewRow());

			Assert.AreEqual(_tstLT.SpecimenTestThresholdGuid, (System.Guid) dr[TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid]);
			Assert.AreEqual(_tstLT.ComponentClassId, Convert.ToInt32(dr[TABLES.SpecimenTestThreshold.ComponentClassId].ToString()));
			Assert.AreEqual(_tstLT.LabTestName, dr[TABLES.SpecimenTestThreshold.VistaLaboratoryTestName].ToString());
			Assert.AreEqual(_tstLT.SpecimenType, Common.Utility.GetSpecimenTypeFromString(dr[TABLES.SpecimenTestThreshold.SpecimenTypeCode].ToString()));
			Assert.AreEqual(_tstLT.LabTestId.ToString().Trim(), dr[TABLES.SpecimenTestThreshold.LabTestId].ToString().Trim());
			Assert.AreEqual(_tstLT.Threshold, dr.IsNull("ThresholdResult") ? "" : dr[TABLES.SpecimenTestThreshold.ThresholdResult].ToString());
			Assert.AreEqual(Convert.ToInt32(_tstLT.ReportType), Convert.ToInt32(dr[TABLES.SpecimenTestThreshold.ReportTypeId].ToString()));
			Assert.AreEqual(_tstLT.RecordStatusCode, Common.Utility.GetRecordStatusCodeFromString(dr[TABLES.SpecimenTestThreshold.RecordStatusCode].ToString()));

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void GetLabTests_Pass()
		{		
			DataTable dtTest = this._tstLT.GetLabTests();

			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetLabTests_Fail()
		{
		}

		[Test]
		public void SaveLabTests_Pass()
		{
			this.RefreshData = true;

			DataTable dtTest = this._dtLabTest.Copy();
			dtTest.Rows[0][TABLES.SpecimenTestThreshold.VistaLaboratoryTestName] = System.DateTime.Now.ToString();

			_tstLT.SaveLabTests(dtTest, Common.UpdateFunction.UnitTests);

			Assert.IsTrue(true);		//No RC to check
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void SaveLabTests_Fail()
		{
			DataTable dtTest = this._dtLabTest.Copy();
			dtTest.AcceptChanges();

			dtTest.Rows[0][TABLES.SpecimenTestThreshold.VistaLaboratoryTestName] = System.DateTime.Now.ToString();
			dtTest.Rows[0][TABLES.SpecimenTestThreshold.RowVersion] = new byte[8];
			
			
			_tstLT.SaveLabTests(dtTest, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void Clear_Pass()
		{
			this._tstLT.Clear();

			Assert.AreEqual(System.Int32.MinValue, _tstLT.ComponentClassId);
			Assert.AreEqual(string.Empty, _tstLT.LabTestName);
			Assert.AreEqual(Common.SpecimenType.Unknown, _tstLT.SpecimenType);
			Assert.AreEqual(System.Int32.MinValue, _tstLT.LabTestId);
			Assert.AreEqual(string.Empty, _tstLT.Threshold);
			Assert.AreEqual(Common.ReportType.Unknown, _tstLT.ReportType);
			Assert.AreEqual(Common.RecordStatusCode.Unknown, _tstLT.RecordStatusCode);
			Assert.AreEqual(false, _tstLT.IsDirty);
			Assert.AreEqual(true, _tstLT.IsNew);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Clear_Fail()
		{
		}

		[Test]
		public void GetSpecimenTestThresholdTableSchema_Pass()
		{
			DataTable dtTest = BOL.LabTest.GetSpecimenTestThresholdTableSchema();

			Assert.IsNotNull(dtTest);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(12, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetSpecimenTestThresholdTableSchema_Fail()
		{
		}

		[Test]
		public void GetVistaLabTests_Pass()
		{
			DataTable dtTest = BOL.LabTest.GetVistALabTests(this._tstLT.LabTestName);

			Assert.IsNotNull(dtTest);
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void  GetVistaLabTests_Fail()
		{
			BOL.LabTest.GetVistALabTests(null);
		}

		[Test]
		public void GetVistaLabTestResults_Pass()
		{
			// Get Transfused units from the last 365 days.
			DataTable _transfusedUnits = BOL.PatientTransfusion.GetTransfusedUnitsInDateRange(DateTime.Today.AddYears(-1), DateTime.Today);
			if (_transfusedUnits.Rows.Count == 0)
			{
				new BOL.UnitTests.BOL_PatientTransfusionReaction().SaveImplicatedBloodUnits_Pass();
				_transfusedUnits = BOL.PatientTransfusion.GetTransfusedUnitsInDateRange(DateTime.Today.AddYears(-1), DateTime.Today.AddDays(1));
				if (_transfusedUnits.Rows.Count == 0) throw new Exception("No Transfused Units");
			}

			ArrayList patientArray = new ArrayList();
			//
			foreach(DataRow dr in _transfusedUnits.Rows)
			{
				if (patientArray.IndexOf(dr[TABLES.Patient.VistaPatientId].ToString())<0)
				{
					patientArray.Add(dr[TABLES.Patient.VistaPatientId].ToString());
				}
			}

			BOL.LabTest labTest = new BOL.LabTest();
			labTest.ReportType = Common.ReportType.TransfusionComplication;
			DataTable allLabTests = labTest.GetLabTests();
			//
			DataTable _labTests = allLabTests.Clone();
			ArrayList _labTestArray = new ArrayList();
			//
			foreach(DataRow dr in allLabTests.Rows)
			{
				if (Common.Utility.GetRecordStatusCodeFromString(dr[TABLES.SpecimenTestThreshold.RecordStatusCode].ToString()) == Common.RecordStatusCode.Active)
				{
					_labTests.Rows.Add(dr.ItemArray);
					_labTestArray.Add(dr[TABLES.SpecimenTestThreshold.LabTestId].ToString().Trim());
				}
			}
			try
			{
				DataTable labTests = BOL.LabTest.GetVistALabTestResults(DateTime.Today.AddYears(-1), DateTime.Today.AddDays(1), UnitTestConfig.TestDivisionCode ,_labTestArray , patientArray);
				Assert.IsTrue(labTests.Rows.Count>0,"Row.Count");
			}
			catch(BOL.BusinessObjectException)
			{
				Assert.IsTrue(true,"There are no Vista Lab Tests to retrieve");
			}

		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void  GetVistaLabTestResults_Fail()
		{
			ArrayList patientArray = new ArrayList();
			ArrayList _labTestArray = new ArrayList();

			Assert.IsTrue(BOL.LabTest.GetVistALabTestResults(DateTime.Today.AddYears(-1), DateTime.Today, UnitTestConfig.TestDivisionCode ,_labTestArray , patientArray).Rows.Count<1);
		}


		[Test]
		public void GetSpecimenTestThresholds_Pass()
		{
			int ccId = (int)_drLabTest[TABLES.SpecimenTestThreshold.ComponentClassId];
			string _tstLTId = _drLabTest[TABLES.SpecimenTestThreshold.LabTestId].ToString();

			DataTable dtTest = DAL.LabTest.GetSpecimenTestThresholds(ccId, _tstLTId);
			
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetSpecimenTestThresholds_Fail()
		{
			int ccId = -1;
			string _tstLTId = "-1";

			DataTable dtTest = DAL.LabTest.GetSpecimenTestThresholds(ccId, _tstLTId);
			
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}


		[Test]
		public void DoTestsExceedThreshold_Pass()
		{
			DataTable dtTests = new DataTable();
			dtTests.Columns.Add(TABLES.PatientTest.LabTestId, typeof(int));
			dtTests.Columns.Add(TABLES.PatientTest.TestResult, typeof(string));
			
			DataRow dr = dtTests.NewRow();
			dr[TABLES.PatientTest.LabTestId] = 4;
			dr[TABLES.PatientTest.TestResult] = 1.23;
			dtTests.Rows.Add(dr);

			System.Collections.ArrayList alTest = BOL.LabTest.DoTestsExceedThreshold(3, dtTests);

			Assert.IsNotNull(alTest);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DoTestsExceedThreshold_Fail()
		{
		}








	}
}
#endif




